/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.common.collect.Sets;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.mixin.NativeImageAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import org.jetbrains.annotations.Nullable;

public class LBGResourcePack
implements class_3262 {
    private static final Set<String> NAMESPACES = Sets.newHashSet((Object[])new String[]{"lambdabettergrass"});
    private final Object2ObjectMap<String, byte[]> resources = new Object2ObjectOpenHashMap();
    private final LambdaBetterGrass mod;

    public LBGResourcePack(LambdaBetterGrass mod) {
        this.mod = mod;
    }

    public void putResource(String resource, byte[] data) {
        this.resources.put((Object)resource, (Object)data);
    }

    public void putImage(String location, class_1011 image) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        WritableByteChannel out = Channels.newChannel(byteOut);
        ((NativeImageAccessor)image).lbg$write(out);
        if (this.mod.config.isDebug()) {
            File file = new File("debug/lbg_out/" + location);
            file.getParentFile().mkdirs();
            try {
                FileChannel outF = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                ((NativeImageAccessor)image).lbg$write(outF);
                outF.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.putResource(location, byteOut.toByteArray());
        try {
            out.close();
        }
        catch (IOException e) {
            this.mod.warn("Could not close output channel for texture " + location + ". Exception: " + e.getMessage());
        }
    }

    public class_2960 dynamicallyPutImage(String name, class_1011 image) {
        this.putImage("assets/lambdabettergrass/textures/bettergrass/" + name + ".png", image);
        return new class_2960("lambdabettergrass", "bettergrass/" + name);
    }

    public InputStream method_14410(String fileName) throws IOException {
        byte[] data = (byte[])this.resources.get((Object)fileName);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        throw new IOException("Generated resources pack has no data or alias for " + fileName);
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        if (type == class_3264.field_14190) {
            throw new IOException("Reading server data from LambdaBetterGrass client resource pack");
        }
        return this.method_14410(type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832());
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, Predicate<class_2960> predicate) {
        if (type == class_3264.field_14190) {
            return Collections.emptyList();
        }
        String start = "assets/" + namespace + "/" + prefix;
        return this.resources.keySet().stream().filter(s -> s.startsWith(start)).map(LBGResourcePack::fromPath).filter(id -> id != null && predicate.test((class_2960)id)).collect(Collectors.toList());
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        String path = type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832();
        return this.resources.containsKey((Object)path);
    }

    public Set<String> method_14406(class_3264 type) {
        return NAMESPACES;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        return null;
    }

    public String method_14409() {
        return "LambdaBetterGrass generated resources";
    }

    public void close() {
    }

    @Nullable
    private static class_2960 fromPath(String path) {
        String[] split = path.substring("assets/".length()).split("/", 2);
        return class_2960.method_43902((String)split[0], (String)split[1]);
    }
}

